﻿/*
 * Copyright (c) 2013, M@T
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of the <organization> nor the
 *       names of its contributors may be used to endorse or promote products
 *       derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL M@T BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

using System;
using System.Drawing;
using System.Drawing.Imaging;
using System.Runtime.InteropServices;
using System.Windows.Forms;

namespace LibertyTicket_Distro_ROM_Editor
{
    public partial class frm_Image : Form
    {
        public frm_Image()
        {
            InitializeComponent();
        }

        private byte[] convert32bppTo16bpp(Bitmap img)
        {
            for (int y = 0; y < img.Height; y++)
                for (int x = 0; x < img.Width; x++)
                {
                    var color = img.GetPixel(x, y);
                    img.SetPixel(x, y, Color.FromArgb(255, color.B, color.G, color.R));
                }

            var imgData = img.LockBits(new Rectangle(0, 0, img.Width, img.Height), ImageLockMode.ReadOnly, PixelFormat.Format16bppArgb1555);

            byte[] data = new byte[256 * 192 * 2];
            Marshal.Copy(imgData.Scan0, data, 0, data.Length);

            img.UnlockBits(imgData);

            return data;
        }

        private Bitmap convert16bppTo32bpp(byte[] data)
        {
            Bitmap img = new Bitmap(256, 192);

            BitmapData imgData = img.LockBits(new Rectangle(0, 0, img.Width, img.Height), ImageLockMode.WriteOnly, PixelFormat.Format16bppArgb1555);

            Marshal.Copy(data, 0, imgData.Scan0, data.Length);

            img.UnlockBits(imgData);

            for (int y = 0; y < img.Height; y++)
                for (int x = 0; x < img.Width; x++)
                {
                    var color = img.GetPixel(x, y);
                    img.SetPixel(x, y, Color.FromArgb(255, color.B, color.G, color.R));
                }

            return img;
        }

        private void frm_Image_Load(object sender, EventArgs e)
        {
            frm_Main parent = (frm_Main)this.Owner;
            byte[] data = new byte[256 * 192 * 2];

            frm_Main.ms.Position = frm_Main.BgOffset + parent.arm7Offset;
            frm_Main.ms.Read(data, 0, data.Length);

            pb_Preview.Image = convert16bppTo32bpp(data);
        }

        private void b_OpenImg_Click(object sender, EventArgs e)
        {
            if (openFileDialog1.ShowDialog() == DialogResult.OK)
            {
                try
                {
                    Bitmap img = new Bitmap(openFileDialog1.FileName);
                    double xScale = 256d / img.Width;
                    double yScale = 192d / img.Height;
                    double minScale = Math.Min(xScale, yScale);
                    int newWidth = (int)(img.Width * minScale);
                    int newHeight = (int)(img.Height * minScale);
                    Bitmap image = new Bitmap(img.GetThumbnailImage(newWidth, newHeight, null, IntPtr.Zero));

                    Bitmap output = new Bitmap(256, 192);

                    int offsetX = (256 - newWidth) / 2;
                    int offsetY = (192 - newHeight) / 2;
                    Graphics graphics = Graphics.FromImage(output);
                    graphics.Clear(Color.White);
                    graphics.DrawImage(image, new Point(offsetX, offsetY));

                    pb_Preview.Image = output;
                    img.Dispose();
                    image.Dispose();
                }
                catch (Exception)
                {
                    MessageBox.Show("Ce n’est pas une image valide.", "Erreur : image invalide", MessageBoxButtons.OK, MessageBoxIcon.Error);
                }
            }
        }

        private void b_Validate_Click(object sender, EventArgs e)
        {
            frm_Main parent = (frm_Main)this.Owner;
            byte[] data = convert32bppTo16bpp((Bitmap)pb_Preview.Image);

            frm_Main.ms.Position = frm_Main.BgOffset + parent.arm7Offset;
            frm_Main.ms.Write(data, 0, data.Length);

            this.Close();
        }

        private void b_Cancel_Click(object sender, EventArgs e)
        {
            this.Close();
        }
    }
}
